<?php
// Connection setup
$servername = "localhost"; 
$username = "root"; 
$password = "Inf!Care2025@DB"; 
$dbname = "Web_Membershipanywhere"; 

$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Capture form data and step
$fname = $_POST['fname'] ?? null;
$email = $_POST['email'] ?? null;
$organization = $_POST['organization'] ?? null;
$oms = $_POST['oms'] ?? null;
$nom = $_POST['nom'] ?? null;
$membership = $_POST['membership'] ?? null;
$interested = $_POST['productsins'] ?? null;
$aboutus = $_POST['aboutus'] ?? null;
$comments = $_POST['comments'] ?? null;

// Validate required fields
if (empty($fname) || empty($email)) {
    die("Error: First name and email are required.");
}

// Determine status based on the presence of interested data
$status = empty($comments) ? '0' : '1';

// Prepare the insert/update statement based on the email
$stmt = $conn->prepare("SELECT * FROM pricepage WHERE email = ? AND status = '0' LIMIT 1");
if (!$stmt) {
    die("Error preparing statement: " . htmlspecialchars($conn->error));
}

$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // Record exists, prepare an update
    $stmt = $conn->prepare("UPDATE pricepage SET fname = ?, organization = ?, oms = ?, nom = ?, membership = ?, interested = ?, aboutus = ?,  comments = ?, status = ? WHERE email = ? AND status = '0'");
    if (!$stmt) {
        die("Error preparing update statement: " . htmlspecialchars($conn->error));
    }
    
    $stmt->bind_param("ssssssssss", $fname, $organization, $oms, $nom, $membership, $interested, $aboutus, $comments, $status, $email);
} else {
    // No record found, prepare an insert
    $stmt = $conn->prepare("INSERT INTO pricepage (fname, email, organization, oms, nom, membership, interested, aboutus, comments, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    if (!$stmt) {
        die("Error preparing insert statement: " . htmlspecialchars($conn->error));
    }
    
    $stmt->bind_param("ssssssssss", $fname, $email, $organization, $oms, $nom, $membership, $interested, $aboutus, $comments, $status);
}

// Execute statement
if ($stmt->execute()) {
    $step = $_POST['step'] ?? 'N/A'; // Default to 'N/A' if step is not set
    echo "Data submitted successfully for step " . htmlspecialchars($step);
} else {
    echo "Error executing statement: " . htmlspecialchars($stmt->error);
}

// Close statement and connection
$stmt->close();
$conn->close();
?>
