<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>




<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
<div class="container blog-post">
	<header class="entry-header alignwide">
		<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
		<?php
		$excerpt = get_the_excerpt();
		$excerpt = wp_trim_words($excerpt, 50, '...');
		echo '<p>' . $excerpt . '</p>';
		?>
		<div class="author">
			<div>
				<?php echo get_avatar( get_the_author_meta('ID'), 40 ); ?>
			</div>
			<div style="padding-left:15px;">
				By <?php echo get_the_author_meta('display_name');?> <br/>
				<span style="color:rgba(0, 0, 0, 0.50);">Published on <?php echo get_the_date('F j, Y'); ?></span>
			</div>
			
		</div>
		<?php twenty_twenty_one_post_thumbnail(); ?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<div class="readingtime">
			<div>
				<?php echo do_shortcode('[rt_reading_time]');?><span>min read</span>
			</div>
			<?php echo do_shortcode( '[socialshare]' ); ?>
		</div>
		<div class="line"></div>
		<?php
		the_content();

		wp_link_pages(
			array(
				'before'   => '<nav class="page-links" aria-label="' . esc_attr__( 'Page', 'twentytwentyone' ) . '">',
				'after'    => '</nav>',
				/* translators: %: Page number. */
				'pagelink' => esc_html__( 'Page %', 'twentytwentyone' ),
			)
		);
		?>
	</div><!-- .entry-content -->
	</div>
	<section class="muse_booksection">
	<div class="container">
	<h3 class="muse_booksectionHead2">Deliver the experience your visitors are waiting for.</h3>
	<a class="muse_bookcal" href="https://membershipanywhere.com/learnmore/">Book a demo</a></div>
	</section>
	<footer class="entry-footer default-max-width">
		<?php twenty_twenty_one_entry_meta_footer(); ?>
	</footer><!-- .entry-footer -->

	<?php if ( ! is_singular( 'attachment' ) ) : ?>
		<?php get_template_part( 'template-parts/post/author-bio' ); ?>
	<?php endif; ?>

</article><!-- #post-<?php the_ID(); ?> -->
