<?php
/*Template Name: Pricing Form Page*/
?>

<?php get_header(); ?>
<!-- Learn More Button to Trigger Modal -->
<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#membershipFormModal">
  Learn More
</button>

<!-- Modal Structure -->
<div class="modal fade" id="membershipFormModal" tabindex="-1" role="dialog" aria-labelledby="membershipFormModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="membershipFormModalLabel">Membership Information</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <!-- Step 1 -->
        <div id="form-section-1">
          <div class="form-group">
            <label for="name">Your Name</label>
            <input type="text" class="form-control" id="name" required>
          </div>
          <div class="form-group">
            <label for="email">Email Address</label>
            <input type="email" class="form-control" id="email" required>
          </div>
          <button type="button" id="continue-step-1" class="btn btn-primary">Continue</button>
        </div>

        <!-- Step 2 -->
        <div id="form-section-2" style="display:none;">
          <div class="form-group">
            <label for="organization">Organization Name</label>
            <input type="text" class="form-control" id="organization" required>
          </div>
          <div class="form-group">
            <label for="membership-system">Membership System</label>
            <select class="form-control" id="membership-system">
              <option value="System A">System A</option>
              <option value="System B">System B</option>
            </select>
          </div>
          <button type="button" id="back-step-2" class="btn btn-secondary">Back</button>
          <button type="button" id="continue-step-2" class="btn btn-primary">Continue</button>
        </div>

        <!-- Step 3 -->
        <div id="form-section-3" style="display:none;">
          <div class="form-group">
            <label for="num-members">Number of Members</label>
            <input type="number" class="form-control" id="num-members" required>
          </div>
          <div class="form-group">
            <label for="membership-system-2">Which Membership System do you use?</label>
            <select class="form-control" id="membership-system-2">
              <option value="System A">System A</option>
              <option value="System B">System B</option>
            </select>
          </div>
          <button type="button" id="back-step-3" class="btn btn-secondary">Back</button>
          <button type="button" id="continue-step-3" class="btn btn-primary">Continue</button>
        </div>

        <!-- Step 4 -->
        <div id="form-section-4" style="display:none;">
          <h5>Select Your Options</h5>
          <div id="form-step-4">
            <div class="form-check">
              <input type="checkbox" class="form-check-input" id="digital-membership-cards">
              <label class="form-check-label" for="digital-membership-cards">Digital membership cards</label>
            </div>
            <div class="form-check">
              <input type="checkbox" class="form-check-input" id="automated-renewal-reminders">
              <label class="form-check-label" for="automated-renewal-reminders">Automated renewal reminders</label>
            </div>
            <div class="form-check">
              <input type="checkbox" class="form-check-input" id="sms-texting">
              <label class="form-check-label" for="sms-texting">SMS texting</label>
            </div>
            <!-- Add more checkboxes as needed -->
          </div>
          <button type="button" id="back-step-4" class="btn btn-secondary">Back</button>
          <button type="button" id="continue-step-4" class="btn btn-primary">Continue</button>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Inline JavaScript Code -->
<script>
jQuery(document).ready(function($) {
    // Step 1: Continue to Step 2
    $('#continue-step-1').on('click', function() {
        if ($('#name').val() && $('#email').val()) {
            $('#form-section-1').hide();
            $('#form-section-2').show();
        } else {
            alert('Please fill out all fields.');
        }
    });

    // Step 2: Back to Step 1
    $('#back-step-2').on('click', function() {
        $('#form-section-2').hide();
        $('#form-section-1').show();
    });

    // Step 2: Continue to Step 3
    $('#continue-step-2').on('click', function() {
        if ($('#organization').val() && $('#membership-system').val()) {
            $('#form-section-2').hide();
            $('#form-section-3').show();
        } else {
            alert('Please fill out all fields.');
        }
    });

    // Step 3: Back to Step 2
    $('#back-step-3').on('click', function() {
        $('#form-section-3').hide();
        $('#form-section-2').show();
    });

    // Step 3: Continue to Step 4
    $('#continue-step-3').on('click', function() {
        if ($('#num-members').val() && $('#membership-system-2').val()) {
            $('#form-section-3').hide();
            $('#form-section-4').show();
        } else {
            alert('Please fill out all fields.');
        }
    });

    // Step 4: Back to Step 3
    $('#back-step-4').on('click', function() {
        $('#form-section-4').hide();
        $('#form-section-3').show();
    });

    // Step 4: Submit the form via AJAX
    $('#continue-step-4').on('click', function() {
        // Collect form data
        var data = {
            name: $('#name').val(),
            email: $('#email').val(),
            organization: $('#organization').val(),
            membership_system: $('#membership-system').val(),
            num_members: $('#num-members').val(),
            membership_system_2: $('#membership-system-2').val(),
            options: []
        };

        // Collect checkbox data
        $('#form-step-4 input[type=checkbox]').each(function() {
            if ($(this).is(':checked')) {
                data.options.push($(this).next().text());
            }
        });

        // Send data via AJAX
        $.post({
            url: ajax_object.ajaxurl,  // Use localized ajaxurl
            data: {
                action: 'send_form_data',
                form_data: data
            },
            success: function(response) {
                if (response.success) {
                    window.location.href = 'https://external-url.com'; // Replace with your external URL
                } else {
                    alert('There was an error sending the email.');
                }
            }
        });
    });
});
</script>

<?php get_footer(); ?>