<?php
/*Template Name: Blog Page*/
?>

<?php get_header(); ?>
<section class="blog-panel">
<div class="container-fluid">
<h1 class="muse-bannerheading">Recent articles</h1>
<div class="row">
<?php
$args = array(
'numberposts' => 15,          
'post_type'   => 'post',     
'orderby'     => 'date',     
'order'       => 'date'      
);
    $recent_posts = get_posts($args);
    if (!empty($recent_posts)) :
    foreach ($recent_posts as $post) : setup_postdata($post); ?>
          <div class="col-lg-4 col-md-4 col-sm-12">
                <div class="card muse_threeblock_card">
                  <a href="<?php the_permalink(); ?>">
                  <?php if (has_post_thumbnail($post->ID)): ?>
                    <?php echo get_the_post_thumbnail($post->ID, 'large'); ?>
                  <?php else: ?>
                    <img src="<?php echo esc_url(get_template_directory_uri() . '/images/default.png'); ?>" alt="Default thumbnail">
                  <?php endif; ?>
                  </a>
                <div class="card-body">
                <h5 class="card-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                <p class="reading"><?php echo do_shortcode('[rt_reading_time]'); ?> minute read</p>
                </div>
                </div>
          </div>
    <?php endforeach;
    wp_reset_postdata();
    else :
    echo '<p>No recent posts found.</p>';
    endif;
?>
</div>
</div>
</section>
<section class="blog-panel muse_booksection">
<div class="container">
<h3 class="muse_booksectionHead2">Deliver the experience your visitors are waiting for.</h3>
<a class="muse_bookcal" href="https://membershipanywhere.com/learnmore/">Book a demo</a></div>
</section>
<?php get_footer(); ?>